/*
 * QrfeGen2ManipulatorInterface.h
 *
 *  Created on: 12.08.2010
 *      Author: stefan.detter
 */

#ifndef QRFEGEN2ADVANCEDMANIPULATORINTERFACE_H_
#define QRFEGEN2ADVANCEDMANIPULATORINTERFACE_H_

#include "epc/EPC_Defines.h"
#include "QrfeReaderInterfaceGlobal.h"
#include "QrfeGen2ManipulatorInterface.h"

class QrfeGen2AdvancedManipulatorInterface : public QrfeGen2ManipulatorInterface
{
public:
    QrfeGen2AdvancedManipulatorInterface(){};
    virtual ~QrfeGen2AdvancedManipulatorInterface(){};

	virtual QrfeGlobal::TMIResult blockWriteToTag ( const QByteArray& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, uchar blockSize, const QByteArray& data ) = 0;

	virtual QrfeGlobal::TMIResult getTagHandle ( const QString& tagId, QByteArray &handle ) = 0;
    virtual QrfeGlobal::TMIResult readFromHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, uchar count, QByteArray &data ) = 0;
    virtual QrfeGlobal::TMIResult writeToHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, const QByteArray& data ) = 0;
	virtual QrfeGlobal::TMIResult blockWriteToHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, uchar blockSize, const QByteArray& data ) = 0;

	virtual QrfeGlobal::TMIResult customGen2Command ( const QByteArray& handle, const QByteArray& command, const QByteArray& passwd, uchar txBitCount, const QByteArray& txBits, bool& headerBit, QByteArray& rxBytes ) = 0;

	virtual QrfeGlobal::TMIResult nxp_setReadProtect ( const QString& tagId, const QByteArray& passwd ) = 0;
	virtual QrfeGlobal::TMIResult nxp_resetReadProtect ( const QString& tagId, const QByteArray& passwd ) = 0;
	virtual QrfeGlobal::TMIResult nxp_sendCmdToCtrler ( const QString& tagId, uchar cmd, const QByteArray& cmdData ) = 0;
};

#endif /* QRFEGEN2ADVANCEDMANIPULATORINTERFACE_H_ */
